IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Centro_Costos_Saldos_Resumen_Anual_Detallado') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CPJ_Centro_Costos_Saldos_Resumen_Anual_Detallado
END
GO


CREATE PROCEDURE dbo.CPJ_Centro_Costos_Saldos_Resumen_Anual_Detallado @pJsonRecibido VARCHAR(8000)
AS 
SET NOCOUNT ON

/*Variables Recibidas por Parametros*/
DECLARE	@pId_Usuario			INT
DECLARE	@pFlagUsarTrans			TINYINT
DECLARE	@pModoDebug				TINYINT

DECLARE	@pAnio					SMALLINT
DECLARE @pId_Centro_Costo		VARCHAR(10)

SET @pId_Usuario				= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Usuario')), 0)
SET @pFlagUsarTrans				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'FlagUsarTrans')), 0)
SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'ModoDebug')), 0)

SET @pAnio				        = ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Anio')), 0)
SET @pId_Centro_Costo	        = ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Centro_Costo')), '')
/*FIN Variables Recibidas por Parametros*/

/*Variables Locales*/
DECLARE @Id_Centro_Costo						VARCHAR(10)
DECLARE @CC_Descripcion							VARCHAR(200)
DECLARE @Id_Centro_Costo_Saldo_Mas_Reciente		INT
DECLARE @Periodo_Mas_Reciente					DATE
DECLARE @Saldo_Mas_Reciente						DECIMAL(16,2)

DECLARE @rta_CPJ_Centro_Costos_Saldos_Resumen_Anual_Detallado		TABLE (	Mes				TINYINT,
																			Periodo			DATE,
																			SA				DECIMAL(16,2),
																			Ingresos		DECIMAL(16,2),
																			Egresos			DECIMAL(16,2),
																			Saldo			DECIMAL(16,2),
																			Nota			TEXT,
																			Flag_Generado	TINYINT)
DECLARE @Mes									TINYINT
DECLARE @Id_Centro_Costo_Saldo_Mes_Seleccionado	INT
DECLARE @Periodo								DATE
/*FIN Variables Locales*/

-------------------------------------------------------------------------------------------------------------------------------------------------------

IF(@pModoDebug = 1)
BEGIN
	PRINT 'Ingreso a CPJ_Centro_Costos_Saldos_Resumen_Anual_Detallado'
END


-------------------------------------------------------------------------------------------------------------------------------------------------------

SET @Mes = 0

WHILE @Mes < 12
BEGIN
	SET @Mes = @Mes + 1
	SET @Periodo = CONVERT(DATE, (CONVERT(VARCHAR(10), @pAnio) + CONVERT(VARCHAR(2), RIGHT('00' + CAST(@Mes AS VARCHAR), 2)) + '01'))

	IF(@pModoDebug = 1)
	BEGIN
		PRINT '@Mes: ' + CONVERT(VARCHAR(2), RIGHT('00' + CAST(@Mes AS VARCHAR), 2)) + '. Periodo: ' + CONVERT(VARCHAR(10), @Periodo, 102)
	END

	SET @Id_Centro_Costo_Saldo_Mes_Seleccionado = ISNULL((SELECT MAX(Id_Centro_Costo_Saldo)
														FROM Centro_Costos_Saldos CCS
														WHERE
														CCS.Id_Centro_Costo = @pId_Centro_Costo
														AND CCS.Periodo = @Periodo)
														, 0)
	IF(@pModoDebug = 1)
	BEGIN
		PRINT '@Id_Centro_Costo_Saldo_Mes_Seleccionado: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo_Saldo_Mes_Seleccionado) 
	END

	IF(@Id_Centro_Costo_Saldo_Mes_Seleccionado > 0)
	BEGIN
		INSERT INTO @rta_CPJ_Centro_Costos_Saldos_Resumen_Anual_Detallado 
		(Mes,	Periodo,	SA,		Ingresos,	Egresos,	Saldo,	Nota,	Flag_Generado) 
		SELECT 
		@Mes,	Periodo,	SA,		Ingresos,	Egresos,	Saldo,	Nota,	1
		FROM Centro_Costos_Saldos
		WHERE
		Id_Centro_Costo_Saldo = @Id_Centro_Costo_Saldo_Mes_Seleccionado
	END
	ELSE
	BEGIN
		INSERT INTO @rta_CPJ_Centro_Costos_Saldos_Resumen_Anual_Detallado (Mes, Flag_Generado) VALUES (@Mes, 0)
	END
END

-------------------------------------------------------------------------------------------------------------------------------------------------------

SELECT * FROM @rta_CPJ_Centro_Costos_Saldos_Resumen_Anual_Detallado

-------------------------------------------------------------------------------------------------------------------------------------------------------

IF(@pModoDebug = 1)
BEGIN
	PRINT 'FIN CPJ_Centro_Costos_Saldos_Resumen_Anual_Detallado'
END

/*
EXEC dbo.CPJ_Centro_Costos_Saldos_Resumen_Anual_Detallado   '{
															"Id_Usuario":"-1",
															"FlagUsarTrans":"0",
															"ModoDebug":"1",
															"Anio":"2021",
															"Id_Centro_Costo":"7"
															}'
*/